<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Alterar registo') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <form method="POST" enctype="multipart/form-data" id="upload" action="{{route('registo.edit', ['valor'=>$registo->id, 'ok'=>1])}}">
                        @if (session('status'))
                            <div class="w-full my-4 p-2" style="color: green">
                                {{ session('status') }}
                            </div>
                        @endif
                        <div class="w-full mb-6">
                            <label for="">Município*</label>
                            <select class="w-full border border-gray-700 rounded" required name="municipio" id="municipio">
                                @forelse ($municipios as $item)
                                    <option @if ($item->id == $registo->municipio_id) @selected(true) @endif value="{{$item->id}}">{{$item->nome}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum município cadastrado</option>
                                @endforelse
                                
                            </select>
                            @error('municipio') 
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Descrição</label>
                            <input value="{{ $registo->descricao }}" class="w-full border border-gray-700 rounded" max="100" type="text" name="descricao" id="descricao" value="{{ old('descricao') }}">
                            @error('nome')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Categoria*</label>
                            <select  class="w-full border border-gray-700 rounded" required name="categoria" id="categoria">
                                @forelse ($categorias as $item)
                                    <option @if ($item->id == $registo->categoria_id) @selected(true) @endif >{{$item->categoria}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhuma categoria cadastrado</option>
                                @endforelse
                                
                            </select>
                            @error('categoria') 
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        
                        <div class="w-full mb-6">
                            <label for="">Departamento*</label>
                            <select class="w-full border border-gray-700 rounded" required name="departamento" id="departamento">
                                @forelse ($departamentos as $item)
                                    <option @if ($item->id == $registo->departamento_id) @selected(true) @endif value="{{$item->id}}">{{$item->departamento}}</option>
                                @empty
                                    <option @disabled(true) value="">Nenhum departamento cadastrado</option>
                                @endforelse
                                
                            </select>
                            @error('departamento') 
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="w-full mb-6">
                            <label for="">Observação</label>
                            <input value="{{ $registo->nota }}" class="w-full border border-gray-700 rounded" type="text" name="nota" id="nota" value="{{ old('nota') }}">
                            @error('nota')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <a href="{{ asset('assets/img/registos')}}/{{ $registo->anexo }}" target="_blank" >Abrir Anexo 1</a>
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Anexo 1 (PDF, PNG, JPEG, JPG)*</label>
                            <input class="w-full border border-gray-700 rounded" type="file" name="anexo" id="anexo" >
                            @error('anexo')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="w-full mb-6">
                            <a href="{{ asset('assets/img/registos')}}/{{ $registo->anexo1 }}" target="_blank" >Abrir Anexo 2</a>
                        </div>
                        <div class="w-full mb-6">
                            <label for="">Anexo 2 (PDF, PNG, JPEG, JPG)*</label>
                            <input class="w-full border border-gray-700 rounded" type="file" name="anexo1" id="anexo1" >
                            @error('anexo1')
                                <div class="w-full my-4 p-2 border rounded" style="background-color: #f28d75; border-color: #e5322d; color:  #e7322d">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <button class="px-4 py-2 rounded border text-white border-green-900 bg-green-700 hover:bg-green-900 
                        transition duration-300 ease-in-out" type="submit">Salvar</button>
                        @csrf
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
